require( "scripts/style.lua" );






NameFont = {
  standardFont,
  24,
  BorderColor
};

HeaderFont = {
  standardFont,
  48,
  BorderColor
};

ButtonX = kCenter;
ButtonY = 112;
ButtonYSpace = 27;
kNumButtons = 9;


NameButtonGraphics = {
	"buttons/select_none.png",
	"buttons/select_highlight.png",
	"buttons/select_field.png",
	"buttons/select_highlight.png"
};	

NameStyle= {
	type = kRadio,
	flags = kHAlignCenter + kVAlignCenter,
	font = SmallButtonFont,
	graphics = NameButtonGraphics,
	sound = kDefaultButtonSound
};


function SetupMyDinerChoices()
	numDiners = GetNumMyDiners();
	for i=0,kNumButtons do
		if (numDiners > i) then
			EnableWindow('button'..i, true);
			SetCurrentMyDiner(i);
			SetLabel('button'..i, GetMyDinerName());
		else
			EnableWindow('button'..i, false);
		end
	end
	
	if (numDiners > 0) then
		EnableWindow('delete', true);
		EnableWindow('chooseok', true);
		EnableWindow('editname', true);
		EnableWindow('play', true);
		EnableWindow('edit', true);
	else
		EnableWindow('delete', false);
		EnableWindow('chooseok', false);
		EnableWindow('editname', false);
		EnableWindow('play', false);
		EnableWindow('edit', false);
	end
	
	if (numDiners >= kNumButtons) then
		EnableWindow('newdiner', false);
	else
		EnableWindow('newdiner', true);
	end
end


function SetDinerChoice(choiceNum) 
	SetCurrentMyDiner(choiceNum);
	for i=0,kNumButtons do
		if (i == choiceNum) then
			SetChecked('button'..i, true);
		else
			SetChecked('button'..i, false);
		end
	end
end

function SetMyDinerBasedOnButton()
	checkedIndex = -1;
	for i=0, kNumButtons do
		if (GetChecked('button'..i)) then
			checkedIndex = i;
			break;
		end
	end
	SetCurrentMyDiner(checkedIndex);
end

MakeDialog
{
	PopThroughBitmap
	{ 
		image="backgrounds/longdialog",
		x=kCenter,
		y=kCenter,
			
		Text
		{
			font = HeaderFont,
			x=0,y=30,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = "selectmydiner"
		};
		
		
		SetStyle(NameStyle);
		BeginGroup();
		Button{
			name="button0",
			label='',
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*0)
		};
		
		Button{
			name="button1",
			label='',
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*1)
		};
		
		Button{
			name="button2",
			label='',
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*2)
		};
		
		Button{
			name="button3",
			label='',
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*3)
		};
		
		Button{
			name="button4",
			label='',
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*4)
		};
		
		Button{
			name="button5",
			label='',
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*5)
		};
		Button{
			name="button6",
			label='',
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*6)
		};
		Button{
			name="button7",
			label='',
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*7)
		};
		Button{
			name="button8",
			label='',
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*8)
		};
		Button{
			name="button9",
			label='',
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*9)
		};
		SetStyle(DefaultStyle);
		
			
		SetStyle(SmallButtonStyle);
		Button{
			x=30,
			y=75,
			name="newdiner",
			label="newdiner",
			type = kPush,
			command =
				function()
					oldIndex = GetCurrentMyDinerIndex();
					SetCurrentMyDiner(-1);
					name = MyDinerEnterTextDialog(GetDefaultMyDinerName());
					if (not(name == nil)) then
						CreateMyDiner(name);
						newDinerNum = GetNumMyDiners();
						SetCurrentMyDiner(newDinerNum-1);
						SetupMyDinerChoices();
						SetDinerChoice(newDinerNum-1);
						DoModal("scripts/creatingdiner.lua");
						CloseWindow('edit');						
					else
						SetCurrentMyDiner(oldIndex);
					end
				end
		};
		
		Button{
			x=148,
			y=75,
			name="editname",
			label="",
			type = kPush,
			label="editname",
			command =
				function()
					SetMyDinerBasedOnButton();
					checkedIndex = 0;
					for i=0, kNumButtons do
						if (GetChecked('button'..i)) then
							checkedIndex = i;
							break;
						end
					end
					name = MyDinerEnterTextDialog(GetLabel('button'..checkedIndex));
					if (not(name == nil)) then
						SetLabel('button'..checkedIndex, name);
						SetCurrentMyDiner(checkedIndex);
						ChangeMyDinerName(name);
					end
				end
		};
					
		Button{
			x=267,
			y=75,
			name="delete",
			label="deletediner",
			type = kPush,
			command =
				function()
					result = DisplayDialog { 
						"scripts/yesno.lua", 
						body ="deletedinerconfirm",
						title = "",
						popthrough = true
					};
					if (result=='yes') then
						checkedIndex = 0;
						for i=0, kNumButtons do
							if (GetChecked('button'..i)) then
								SetCurrentMyDiner(i);
								DeleteMyDiner();
								newDinerNum = GetNumMyDiners();
								SetupMyDinerChoices();
								if (newDinerNum <= 0) then
									SetDinerChoice(-1);
								elseif (i >= newDinerNum) then
									SetDinerChoice(newDinerNum-1);
								else
									SetDinerChoice(i);
								end
								
								break;
							end
						end
					end
				end
			
		};
		
		SetStyle(SmallButtonStyle);
		Button{
			x=80,
			y=365,
			name="play",
			label="playdiner",
			type = kPush,
			command = 
				function()
					SetMyDinerBasedOnButton();
					CloseWindow('play');
				end
			
		};
		
		Button{
			x=210,
			y=365,
			name="edit",
			label="editdiner",
			type = kPush,
			command = 
				function()
					SetMyDinerBasedOnButton();
					CloseWindow('edit');
				end
			
		};
		
		Button{
			x=140,
			y=395,
			name="cancel",
			label="cancel",
			type = kPush,
			command =
				function()
					CloseWindow('cancel');
				end
			
		};
		
		SetStyle(DefaultStyle);
	}
}

SetupMyDinerChoices();

if (GetNumMyDiners() > 0) then
	SetDinerChoice(0);
end



